/*
 * Decompiled with CFR 0.152.
 */
package mjs.processing.mobile.mvideo;

import java.io.IOException;
import java.io.OutputStream;
import processing.core.PMIDlet;

class MBuffer
extends OutputStream {
    private byte[] bufferData;
    private int count;
    private PMIDlet pMIDlet;

    public MBuffer(PMIDlet pMIDlet) {
        this(128, pMIDlet);
    }

    public MBuffer(int size, PMIDlet pMIDlet) {
        this.bufferData = new byte[size];
        this.pMIDlet = pMIDlet;
    }

    public synchronized void write(int b) throws IOException {
        if (this.count >= this.bufferData.length) {
            byte[] newBufferData = new byte[this.bufferData.length << 1];
            System.arraycopy(this.bufferData, 0, newBufferData, 0, this.count);
            this.bufferData = newBufferData;
        }
        this.bufferData[this.count] = (byte)b;
        ++this.count;
        if (this.pMIDlet != null) {
            byte[] bufferEvent = new byte[]{(byte)b};
            this.pMIDlet.enqueueLibraryEvent(this, 9, bufferEvent);
        }
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        int newCount = this.count + len;
        if (newCount >= this.bufferData.length) {
            byte[] newBufferData = new byte[Math.max(this.bufferData.length << 1, newCount)];
            System.arraycopy(this.bufferData, 0, newBufferData, 0, this.count);
            this.bufferData = newBufferData;
        }
        System.arraycopy(b, off, this.bufferData, this.count, len);
        this.count = newCount;
        if (this.pMIDlet != null) {
            byte[] bufferEvent = new byte[len];
            System.arraycopy(b, off, bufferEvent, 0, len);
            this.pMIDlet.enqueueLibraryEvent(this, 9, bufferEvent);
        }
    }

    public synchronized byte[] toByteArray() {
        byte[] byteArray = new byte[this.count];
        System.arraycopy(this.bufferData, 0, byteArray, 0, this.count);
        return byteArray;
    }

    public void reset() {
        this.count = 0;
    }
}

